define([
	'angular',
	'app'
], function (
	angular,
	app) {
	'use strict';
	app.controller('SudController', function ($scope, $state, $window, $timeout, $log, sudService, pageService, focusService) {
		sudService.getContent().then(function (data) {
			if (!_.isEmpty(data)) {
				$scope.content = data.content;
			}
		}, function (e) {
				$log.error(e);
			}
		);

		$scope.acceptClicked = function () {
			sudService.accept();
			$window.history.back();
		};
		$scope.declineClicked = function () {
			pageService.redirectToLaunchpad();
		};

		$timeout(function(){ focusService.focusMain() });
	});
});